// SAOpenInstTestDlg.h : header file
//

#pragma once
#include "SAOpenInstCtrl1.h"
#include "afxwin.h"


// CSAOpenInstTestDlg dialog
class CSAOpenInstTestDlg : public CDialog
{
// Construction
public:
	CSAOpenInstTestDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_SAOPENINSTTEST_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	CString m_Collection;
	CString m_Group;
	CString m_Target;
	double m_XPos;
	double m_YPos;
	double m_ZPos;
	double m_XUncert;
	double m_YUncert;
	double m_ZUncert;
	double m_ProbeRadius;

	CString m_CloudName;
	double m_CloudXPos;
	double m_CloudYPos;
	double m_CloudZPos;

// Implementation
protected:
	HICON m_hIcon;

	void SetButtons(const BOOL& active);

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();

	afx_msg void OnBnClickedLogonButton();
	afx_msg void OnBnClickedSendmeasurementButton();
	afx_msg void OnBnClickedClearmeasurementsButton();
	afx_msg void OnBnClickedAddmeasurementsButton();

	afx_msg void OnBnClickedClearcloudButton();
	afx_msg void OnBnClickedAddcloudpointButton();
	afx_msg void OnBnClickedSendcloudButton();
	afx_msg void OnBnClickedRandomcloudpointButton();

	DECLARE_MESSAGE_MAP()
public:
	DECLARE_EVENTSINK_MAP()
	
	void OnSetColGroupTargetSaopeninstctrl1(LPCTSTR collectionName, LPCTSTR groupName, LPCTSTR targetName);
	
protected:
	int				 m_NumMeasurements;
	int				 m_NumCloudPoints;
	CEdit m_collectionEditCtrl;
	CEdit m_groupEditCtrl;
	CEdit m_targetEditCtrl;
	CEdit m_XPosEditCtrl;
	CEdit m_YPosEditCtrl;
	CEdit m_ZPosEditCtrl;
	CEdit m_XUncertEditCtrl;
	CEdit m_YUncertEditCtrl;
	CEdit m_ZUncertEditCtrl;
	CEdit m_ProbeRadiusEditCtrl;
	CButton m_ClearMeasBtnCtrl;
	CButton m_AddMeasBtnCtrl;
	CButton m_SendMeasBtnCtrl;
	CButton m_LogonBtnCtrl;
	CEdit m_cloudNameEditCtrl;
	CEdit m_cloudXPosEditCtrl;
	CEdit m_cloudYPosEditCtrl;
	CEdit m_cloudZPosEditCtrl;
	CButton m_clearCloudBtnCtrl;
	CButton m_addCloudBtnCtrl;
	CButton m_sendCloudBtnCtrl;
	CButton m_randomCloudBtnCtrl;
	CSaopeninstctrl1 m_SAOpenInstCtrl;
};
